<?php

namespace Drupal\isimo\Controller;

use Drupal;
use Drupal\Core\Controller\ControllerBase;
use Exception;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Yaml\Yaml;

/**
 * Handles requests for isimo status.
 */
class StatusController extends ControllerBase
{

  public function main($accesskey = null)
  {
    // Validate access key
    $key = \Drupal::config('isimo.settings')->get('accesskey');
    if (empty($accesskey) || empty($key) || $accesskey !== $key) {
      // Not valid, exit
      throw new NotFoundHttpException();
    }

    // Invalidate data for all projects, attempt to re-fetch, and
    // trigger any configured notifications about the new status.
    update_refresh();
    update_fetch_data();

    // Init data array
    $data = [
      'software' => 'Drupal',
      'version'  => Drupal::VERSION,
    ];

    try {
      // Get status report
      module_load_include('inc', 'update', 'update.report');
      $available = update_get_available(true);
      $data['report'] = update_calculate_project_data($available);
    } catch (Exception $e) {
      $data['report'] = 'ERROR:' . $e->getMessage();
    }

    try {
      // Get phpinfo
      ob_start();
      phpinfo();
      $data['phpinfo'] = ob_get_clean();
    } catch (Exception $e) {
      $data['phpinfo'] = 'ERROR:' . $e->getMessage();
    }

    try {
      // Get MySQL info
      $result = Drupal::database()->query('SHOW VARIABLES');
      $data['mysql'] = [];
      while ($row = $result->fetchAssoc()) {
        $data['mysql'][ $row['Variable_name'] ] = $row['Value'];
      }
    } catch (Exception $e) {
      $data['mysql'] = 'ERROR:' . $e->getMessage();
    }

    // Include client version
    try {
      $yml = file_get_contents(__DIR__ . '/../../isimo.info.yml');
      $yml = Yaml::parse($yml);
      if (isset($yml['version'])) {
        $data['client_version'] = $yml['version'];
      }
    } catch (Exception $e) {
      $data['client_version'] = 'ERROR:' . $e->getMessage();
    }

    // Output data
    $out = json_encode($data);
    if ($out) {
      header("Content-type: application/json");
      echo $out;
    } else {
      echo serialize($data);
    }
    exit;

  }

}
