<?php

namespace Drupal\isimo\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure isimo settings for this site.
 */
class SettingsForm extends ConfigFormBase
{

  /**
   * {@inheritdoc}
   */
  public function getFormId()
  {
    return 'isimo_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames()
  {
    return ['isimo.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state)
  {
    $config = $this->config('isimo.settings');

    $form['accesskey'] = [
      '#type'          => 'textfield',
      '#title'         => t('Access key'),
      '#default_value' => $config->get('accesskey'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    // Save key
    $config = $this->config('isimo.settings');
    $key = $form_state->getValue('accesskey');
    $config->set('accesskey', $key);
    $config->save();

    parent::submitForm($form, $form_state);
  }

}
