<?php

namespace Drupal\spiro_utils\Services;

use Drupal\Core\Url;
use Drupal\node\NodeInterface;
use Exception;
use GuzzleHttp\Exception\GuzzleException;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Node helper class
 */
class Http
{

  /**
   * Read JSON from HTTP response and return array
   * @param string $url
   * @return array|null
   */
  public static function getJSON($url)
  {
    // Get response body
    $reponse = self::get($url);
    if (!$reponse) {
      \Drupal::logger('spiro_utils_http')->error('No reponse for ' . $reponse->getTitle());
      return null;
    }

    // Remove HTML comments that may be added to the reponse
    $reponse = preg_replace("/<!--(.*)-->/", '', $reponse);

    // Decode and return response
    return json_decode($reponse);
  }

  /**
   * Read and return HTTP response through Guzzle
   * @param string $url
   * @return string
   */
  public static function get($url)
  {
    // Get Guzzle client
    $client = \Drupal::httpClient();
    try {
      $response = $client->request('GET', $url);
    } catch (GuzzleException $e) {
      \Drupal::logger('isimo_server')->error($e->getMessage(), ['exception' => $e]);
      return '';
    } catch (Exception $e) {
      \Drupal::logger('isimo_server')->error($e->getMessage(), ['exception' => $e]);
      return '';
    }

    // Check status
    if ($response->getStatusCode() !== 200) {
      \Drupal::logger('spiro_utils_http')->error($url . ' returned status ' . $response->getStatusCode());
    }

    // Return response body
    return (string)$response->getBody();
  }

  /**
   * Redirect (exists application)
   * @param string|NodeInterface $url string or node
   * @param array $parameters Optional (used when $url is a route)
   */
  public static function redirect($url, $parameters = [])
  {
    if ($url instanceof NodeInterface) {
      $url = Node::url($url);
    }
    if (strpos($url, '.')) {
      try {
        $temp = Url::fromRoute($url, $parameters);
        if($temp) {
          $url = $temp;
        }
      } catch (Exception $e) {
        // Ignore
      }
    }
    $response = new RedirectResponse($url);
    $response->send();
  }

}
