<?php

namespace Drupal\spiro_utils\Services;

use Drupal\Core\Entity\EntityMalformedException;
use Drupal\node\NodeInterface;

/**
 * Node helper class
 */
class Node
{

  /**
   * Get canoncial url to a node
   * @param NodeInterface $node
   * @return string
   */
  public static function url(NodeInterface $node)
  {
    try {
      return \Drupal::request()->getSchemeAndHttpHost() . $node->toUrl()->toString();
    } catch (EntityMalformedException $e) {
      \Drupal::logger('spiro_utils_node')->error($e);
    }
    return '/';
  }

}
