<?php

namespace Drupal\spiro_utils\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure slack settings.
 */
class SlackSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'spiro_utils_slack_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('spiro.utils.slack.settings');

    $form['webhook'] = [
      '#type' => 'textfield',
      '#title' => t('Webhook endpoint'),
      '#description' => t('Looks like: https://hooks.slack.com/services/XXXXXXXXX/YYYYYYYYY/ZZZZZZZZZZZZZZZZZZZZZZZZ'),
      '#default_value' => $config->get('webhook'),
    ];

    $form['channel'] = [
      '#type' => 'textfield',
      '#title' => t('Channel'),
      '#description' => t('#[channel] or @[username]'),
      '#default_value' => $config->get('channel'),
    ];

    $form['username'] = [
      '#type' => 'textfield',
      '#title' => t('Username'),
      '#description' => t('Sender name. This value is not supported for Slack Apps'),
      '#default_value' => $config->get('username'),
    ];

    $form['icon'] = [
      '#type' => 'textfield',
      '#title' => t('Icon'),
      '#description' => t('Icon / emoji code / image url. This value is not supported for Slack Apps'),
      '#default_value' => $config->get('icon'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Save key
    $config = $this->config('spiro.utils.slack.settings');
    foreach (['webhook', 'channel', 'username', 'icon'] as $key) {
      $value = $form_state->getValue($key);
      $config->set($key, $value);
    }
    $config->save();

    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['spiro.utils.slack.settings'];
  }

}
