<?php

namespace Drupal\spiro_utils\Services;

/**
 * Slack class
 */
class Slack {

  /**
   * Send message to slack
   *
   * @param string $message
   * @param string $icon Optional emoji code or url to custom icon/image.
   *   Defaults to config value.
   * @param string $channel Optional #[channel] or @[username]. Defaults to
   *   config value.
   * @param string $username Optional custom sender name. Defaults to config
   *   value.
   * @param string $webhook Optional custom webhook. Defaults to config value.
   */
  public static function send($message, $icon = NULL, $channel = NULL, $username = NULL, $webhook = NULL) {
    $config = \Drupal::config('spiro.utils.slack.settings');

    // https://api.slack.com/docs/message-formatting#how_to_escape_characters
    // Also use backslashes to escape double quotes/backslashes themselves,
    // that would otherwise break the JSON.
    // (deal with the slashes before the quotes otherwise the escaped quotes would be re-escaped!)
    $replace = [
      '&' => '&amp;',
      '<' => '&lt;',
      '>' => '&gt;',
      '\\' => '\\\\',
      '"' => '\"',
    ];
    $message = str_replace(array_keys($replace), array_values($replace), $message);

    $data = "payload=" . json_encode([
        "username" => $username ? $username : $config->get('username'),
        "channel" => $channel ? $channel : $config->get('channel'),
        "text" => $message,
        "icon_emoji" => $icon ? $icon : $config->get('icon'),
      ]);

    // Post message
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, ($webhook ? $webhook : $config->get('webhook')));
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    $result = curl_exec($ch);
    if ($result === FALSE) {
      // Log error
      \Drupal::logger('spiro_utils_slack')
        ->error('Curl error: ' . curl_error($ch));
    }
  }

}
