<?php

namespace WPML\TM\ATE\ClonedSites\SetupMigration;

use WPML\TM\ATE\ClonedSites\SetupMigration\Resetter\AmsCredentialsCleaner;
use WPML\TM\ATE\ClonedSites\SetupMigration\Resetter\SiteKeyCleaner;
use WPML\TM\ATE\ClonedSites\SetupMigration\Resetter\SetupStepRewinder;

class ClonedSiteResetter {

	/** @var AmsCredentialsCleaner */
	private $credentialsCleaner;

	/** @var SiteKeyCleaner */
	private $siteKeyCleaner;

	/** @var SetupStepRewinder */
	private $setupStepRewinder;

	/**
	 * @param AmsCredentialsCleaner $credentialsCleaner
	 * @param SiteKeyCleaner        $siteKeyCleaner
	 * @param SetupStepRewinder     $setupStepRewinder
	 */
	public function __construct(
		AmsCredentialsCleaner $credentialsCleaner,
		SiteKeyCleaner $siteKeyCleaner,
		SetupStepRewinder $setupStepRewinder
	) {
		$this->credentialsCleaner = $credentialsCleaner;
		$this->siteKeyCleaner     = $siteKeyCleaner;
		$this->setupStepRewinder  = $setupStepRewinder;
	}

	public function reset( string $currentStep ): string {
		$this->credentialsCleaner->clear();
		$this->siteKeyCleaner->unregister();

		return $this->setupStepRewinder->maybeRewindCurrentStep( $currentStep );
	}
}
